package com.jianLing.demo.util;

import okhttp3.*;
import org.springframework.util.StringUtils;

import javax.net.ssl.*;
import java.io.*;
import java.net.*;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

/**
 * 通用http发送方法
 * 
 */
public class HttpUtils
{
    /**
     * 向指定 URL 发送POST方法的请求
     * @param url 发送请求的 URL
     * @param params 请求参数
     * @return 响应结果
     */
//    public static String sendPost(String url, Map<String, Object> params){
//        return sendPost(url, buildParamString(new TreeMap<String, Object>(params), true, true));
//    }

    /**
     * 向指定 URL 发送POST方法的请求
     * @param url 发送请求的 URL
     * @param params 请求参数
     * @return 响应结果
     */
    public static String sendPost(String url, TreeMap<String, Object> params){
        return sendPost(url, buildParamString(params, true, true));
    }

    /**
     * 向指定 URL 发送POST方法的请求
     *
     * @param url 发送请求的 URL
     * @param param 请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
     * @return 所代表远程资源的响应结果
     */
    public static String sendPost(String url, String param)
    {
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try
        {
            String urlNameString = url + "?" + param;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            if (conn instanceof HttpsURLConnection)  {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new java.security.SecureRandom());
                ((HttpsURLConnection) conn).setSSLSocketFactory(sc.getSocketFactory());
                ((HttpsURLConnection) conn).setHostnameVerifier(new TrustAnyHostnameVerifier());
            }

            // 设置15秒超时时间
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);

            conn.setRequestProperty("Accept", "*/*");
            conn.setRequestProperty("Connection", "keep-alive");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(new OutputStreamWriter(conn.getOutputStream(), "utf-8"));
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line;
            while ((line = in.readLine()) != null)
            {
                result.append(line);
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        return result.toString();
    }

    private static class TrustAnyTrustManager implements X509TrustManager
    {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType)
        {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType)
        {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers()
        {
            return new X509Certificate[] {};
        }
    }

    private static class TrustAnyHostnameVerifier implements HostnameVerifier
    {
        @Override
        public boolean verify(String hostname, SSLSession session)
        {
            return true;
        }
    }


    private static final OkHttpClient okHttpClient = new OkHttpClient();
    /**
     * 向指定 URL 发送POST方法的请求
     * @param url 发送请求的 URL
     * @param params 请求参数
     * @return 响应结果
     */
    public static String sendPost(String url, Map<String, Object> params){
        FormBody.Builder builder = new FormBody.Builder();
        if (params != null) {
            for (Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator(); it.hasNext();) {
                Map.Entry<String, Object> ele = it.next();
                builder.add(ele.getKey(), ele.getValue() == null ? "" : ele.getValue().toString());
            }
        }
        RequestBody requestBody = builder.build();
        Request request = new Request.Builder().url(url).post(requestBody).build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String respStr = response.body().string();
                return respStr;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    /**
     * 创建请求参数字符串
     * (不对值进行URL编码)
     * (忽略空值)
     * @param params
     * @return
     */
    public static String buildParamString(Map<String, Object> params) {
        return buildParamString(new TreeMap<>(params), true);
    }

    /**
     * 创建请求参数字符串
     * (不对值进行URL编码)
     * (忽略空值)
     * @param params
     * @return
     */
    public static String buildParamString(TreeMap<String, Object> params) {
        return buildParamString(params, true);
    }
    /**
     * 创建请求参数字符串
     * (不对值进行URL编码)
     * @param params
     * @param isIgnoreEmpty 是否忽略空值
     * @return
     */
    public static String buildParamString(TreeMap<String, Object> params, boolean isIgnoreEmpty) {
        return buildParamString(params, isIgnoreEmpty, false);
    }

    /**
     * 创建请求参数字符串
     * @param params
     * @param isIgnoreEmpty 是否忽略空值
     * @param isUrlEncode 是否对值进行URL编码
     * @return
     */
    public static String buildParamString(TreeMap<String, Object> params, boolean isIgnoreEmpty, boolean isUrlEncode) {
        StringBuilder sb = new StringBuilder();
        for (Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry<String, Object> ele = it.next();
            String value = ele.getValue() == null ? "" : ele.getValue().toString();
            if (isIgnoreEmpty && (StringUtils.isEmpty(value))) {
                continue;
            }
            if (isUrlEncode) {
                try {
                    value = URLEncoder.encode(value, "UTF-8");
                } catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            sb.append("&").append(ele.getKey()).append("=").append(value);
        }

        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }

        return sb.toString();
    }


}