package com.jianLing.demo.controller;


import com.jianLing.demo.util.HttpUtils;
import com.jianLing.demo.util.JsonUtil;
import com.jianLing.demo.util.Md5Utils;
import com.jianLing.demo.util.RsaUtil;
import com.jianLing.demo.vo.*;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;

/**
 * 订单
 * <p>出于demo的简单化考虑，此处将业务逻辑直接写在控制层，实际应用中，应当根据自身的框架，将代码置于业务层，并做必要的事务控制</p>
 * 
 */
@Controller()
@RequestMapping("/order")
public class OrderController
{

    // 下单地址
    private String placeOrderUrl = "http://test.qmz918.com/api/cash/placeCash";
    // 查单地址
    private String queryOrderUrl = "http://test.qmz918.com/api/cash/queryCash";

    // 商户号
    private String merchno = "4b284a5186";
    // 商户秘钥
    private String secretKey = "8305d54f304445aeba27d061c6919477";

    // 商户私钥
    private String privateKey = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCdHEHeWyJII2RerbOIfzRAh0Ko/khwQfmGDtslrZIbehdivVtgQ/u7K27k/VO/XvYO3vedHNBYxkVS9zFtEMzaax0hmEtZEzY9dzW+TL37zHO1jROux4feb6BZyjC+TfFx1amC5Oos86iX2HNNUv5h7hNUtsFMQvkNefzCMG9yaxz890sJ0iWlSvlEYlTofCll06ctWzlHpl4d9zjLE2YjjG9PpjztsStx0tZ24KH7S3yP0oANHTgjORdxP4bz1Rxyj9kNk272SQ8kA0F8K4k82F6Yq7k6XBcksgx6uCwA4WtUYEvsyCBHPZOiFFLNs8anFkaujsFhmC+O3N2QLGblAgMBAAECggEAKuCxYVwB6SovlF9XpiMBQbMokDKF1o1K6jlXudq7C2CwzTPcolMrepOJ+ljg6FOkV76mWWypt/C0rsXj6V4yalHda3PC7JZ/sRq9wifzmarc0WmlO4gdHqncW2UBFI71HBox3xVWi9ob4wUhwrKp1lRBVldiPcvxaKooP180q0b+8yfPasunvPxnSlQVCMheMniyzMqN4nRKF4mYzek550aK5AGOCfIZr3RIvB2hzGxNhGQtPVeOU4i+aW/BDSw+Id3QIjYl2OsW85OQnG3GY4vRXgSuYggU6Sr+L7WyQpSbUUrfhXxlDfVXsMpZ5JlSOLsTfvJenXHpQOBqw7H3wQKBgQDKmsTOqduMsuONeo8KUsNMBfqqp0zsleKtyrEyYRELL32nP5L8p0nUUaeD5T95iSHXKgz0keCh+C8fN0HCLcIu51E/npMN4pXxqxb8sdgR4k5Yqw9S3xY5WY5Sw7sbnIbb91i+JLrhKQRXQTc80/EgpiZQKyZ+QiPlz+v085I6LQKBgQDGhBubDZAjZoIJ/gw1XF1c49tQxsmz4DFf8lnqQN+iigWIctPff5/hpuk5FhNY6JX+0H4oVCaxUX8itF0r130NsGbKNiWQLf5JxoUZTtQ94gWWYEGfMnIqYMvaidjwU8RcudTYk0uzP2UnG4gOv5NRf+5ioeVG7shwEIAg3BVqmQKBgAPmww9vueiVsUgSKhr6yQP3wYHzwslzgW/zTUI5GEjs2zCTStNOrV9HS0CA8531hA9Oof07qeW0j8O8HqoMk4avsaLV/OLxkA2dS84F5rFBeFzAvoTMAvOLw+/YEQxREU+/DZhrwKWBUrITcWrccfI9ANPeYNlhkKtmO5b18cTpAoGAAdg+bW1t1nZgZPlgYaqPD4rqgdCnFS3TJ6IX5c5ehaMktATlJSGJec5UQnyLB3t50VlcosFNbr5kIQ1uBDdHaTYnbl+cb7+Nql/W4spRvJV6GdChK3qLhwtJOamoQ2tz2qy7ZpvPy0WeigN+eyyakNpQe8gnWkZjxG7S0ftZk5kCgYEAltsc+YsZK6GfeFHODUy4aybKBhYhHdyhY1X8PoHersZ5YsT9Zi9F16E35EpWU7bUD+E8gsHcjME3XSCv0dtmidyw8Dv2UIJfOgCrIvWP2arwj7LS/dniaRgCUf/2Jvn5QqPf3ser4PTG4M+IoxcEbOwXqRvxM+iHRlp9XSgN/lc=";

    // 平台公钥
    private String platformPublicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnRxB3lsiSCNkXq2ziH80QIdCqP5IcEH5hg7bJa2SG3oXYr1bYEP7uytu5P1Tv172Dt73nRzQWMZFUvcxbRDM2msdIZhLWRM2PXc1vky9+8xztY0TrseH3m+gWcowvk3xcdWpguTqLPOol9hzTVL+Ye4TVLbBTEL5DXn8wjBvcmsc/PdLCdIlpUr5RGJU6HwpZdOnLVs5R6ZeHfc4yxNmI4xvT6Y87bErcdLWduCh+0t8j9KADR04IzkXcT+G89Ucco/ZDZNu9kkPJANBfCuJPNhemKu5OlwXJLIMergsAOFrVGBL7MggRz2TohRSzbPGpxZGro7BYZgvjtzdkCxm5QIDAQAB";



    /**
     * 构建下单请求参数
     * @param placeOrderParam
     * @return
     */
	@PostMapping("/placeOrder")
    @ResponseBody
    public Object placeOrder(PlaceOrderParam placeOrderParam, HttpServletRequest httpServletRequest)
    {
        StringBuffer url = httpServletRequest.getRequestURL();
        String protocolAndHost = url.delete(url.length() - httpServletRequest.getRequestURI().length(), url.length()).toString();

        ///////////////////////////////
        // 1:省略 验参 步骤
        ///////////////////////////////

        ///////////////////////////////
        // 2:省略 下单入库 步骤
        ///////////////////////////////

        TreeMap<String, Object> reqParams = new TreeMap<>();
        reqParams.put("merchno", merchno);
        reqParams.put("orderId", String.valueOf(System.currentTimeMillis())); // 作为demo，此处直接使用当前毫秒数作为订单号
        reqParams.put("amount", placeOrderParam.getAmount().setScale(2).toString()); // 订单金额必须保留两位小数
        reqParams.put("account", placeOrderParam.getAccount());
        reqParams.put("tradeType", placeOrderParam.getTradeType());
        reqParams.put("cardNo", placeOrderParam.getCardNo());
        reqParams.put("bankName", placeOrderParam.getBankName());
        reqParams.put("depositBank", placeOrderParam.getDepositBank());
        reqParams.put("asyncUrl", protocolAndHost + "/order/asyncCallback");
        reqParams.put("timestamp", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        reqParams.put("attach", placeOrderParam.getAttach());
        reqParams.put("cashType", placeOrderParam.getCashType());
        reqParams.put("requestCurrency", placeOrderParam.getRequestCurrency());
        reqParams.put("apiVersion", placeOrderParam.getApiVersion());


        String toSignStr = HttpUtils.buildParamString(reqParams);
        toSignStr += "&secretKey=" + secretKey;

        // md5生成信息摘要，并转为小写
        String md5Sign = Md5Utils.hash(toSignStr).toLowerCase();

        // 使用RSA2对信息摘要进行签名
        String sign = RsaUtil.sign(md5Sign, privateKey, true);
        reqParams.put("sign", sign);

        String respStr = HttpUtils.sendPost(placeOrderUrl, reqParams);

        if (respStr == null || "".equals(respStr)) {
            ///////////////////////////////
            // 3:网络不可靠因素、服务器报错  等不可预知的原因导致响应为空； 商户根据自身的业务逻辑做相应的处理（例如：发起查单、下单重试等操作）
            ///////////////////////////////
            return "下单响应为空";
        }
        System.out.println("下单响应：" + respStr);

        PlaceOrderResp placeOrderResp = JsonUtil.unmarshal(respStr, PlaceOrderResp.class);
        PlaceOrderResp.ResponseContent responseContent = placeOrderResp.getResponseContent();
        TreeMap<String, Object> respParams = new TreeMap<>();
        respParams.put("code", responseContent.getCode());
        respParams.put("msg", responseContent.getMsg());
        respParams.put("timestamp", responseContent.getTimestamp());
        respParams.put("merchno", responseContent.getMerchno());
        respParams.put("orderId", responseContent.getOrderId());
        respParams.put("orderNo", responseContent.getOrderNo());
        respParams.put("status", responseContent.getStatus());

        toSignStr = HttpUtils.buildParamString(respParams);
        toSignStr += "&secretKey=" +secretKey;
        // md5生成信息摘要，并转为小写
        md5Sign = Md5Utils.hash(toSignStr).toLowerCase();
        // 使用RSA2对信息摘要进行验签
        boolean isVerify = RsaUtil.verify(md5Sign, placeOrderResp.getSign(), platformPublicKey, true);

        if (!isVerify) {
            System.out.println("签名错误");
            return "签名错误:" + respStr;
        }
        if (0 != responseContent.getCode()) {
            ///////////////////////////////
            // 4:省略 根据状态码 结合 商户自身的业务逻辑进行相应的处理（例如：发起查单、下单重试等操作）
            ///////////////////////////////
            System.out.println("下单失败" + respStr);
            return "下单失败" + respStr;
        }

        ///////////////////////////////
        // 5:省略 根据状态码、订单状态 结合 商户自身的业务逻辑进行相应的处理（例如：更新订单状态等操作）
        ///////////////////////////////

        return respStr;
    }

    /**
     * 异步回调通知接口
     * @param callbackParam
     * @return
     */
    @PostMapping("/asyncCallback")
    @ResponseBody
    public Object asyncCallback(CallbackParam callbackParam) {
        ///////////////////////////////
        // 省略 验参 步骤
        ///////////////////////////////

        TreeMap<String, Object> params = new TreeMap<>();
        params.put("timestamp", callbackParam.getTimestamp());
        params.put("orderNo", callbackParam.getOrderNo());
        params.put("merchno", callbackParam.getMerchno());
        params.put("orderId", callbackParam.getOrderId());
        params.put("amount", callbackParam.getAmount());
        params.put("account", callbackParam.getAccount());
        params.put("tradeType", callbackParam.getTradeType());
        params.put("cardNo", callbackParam.getCardNo());
        params.put("bankName", callbackParam.getBankName());
        params.put("depositBank", callbackParam.getDepositBank());
        params.put("attach", callbackParam.getAttach());
        params.put("status", callbackParam.getStatus());

        params.put("apiVersion", callbackParam.getApiVersion());
        params.put("cashType", callbackParam.getCashType());
        params.put("requestCurrency", callbackParam.getRequestCurrency());

        String toSignStr = HttpUtils.buildParamString(params);
        toSignStr += "&secretKey=" + secretKey;

        // md5生成信息摘要，并转为小写
        String md5Sign = Md5Utils.hash(toSignStr).toLowerCase();
        // 使用RSA2对信息摘要进行验签
        boolean isVerify = RsaUtil.verify(md5Sign, callbackParam.getSign(), platformPublicKey, true);

        if (isVerify) {
            ///////////////////////////////
            // 省略 根据订单状态进行订单确认 步骤
            ///////////////////////////////
        }

        System.out.println("异步回调：" + callbackParam + ":::::::::::::" + isVerify) ;

        return isVerify ? "success" : "fail";
    }

    /**
     * 查单 接口
     * @param queryOrderParam
     * @return
     */
    @PostMapping("/queryOrder")
    @ResponseBody
    public Object queryOrder(QueryOrderParam queryOrderParam) {
        ///////////////////////////////
        // 省略 验参 步骤
        ///////////////////////////////

        TreeMap<String, Object> params = new TreeMap<>();
        params.put("merchno", merchno);
        params.put("orderId", queryOrderParam.getOrderId());
        params.put("timestamp", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        params.put("apiVersion", queryOrderParam.getApiVersion());

        String toSignStr = HttpUtils.buildParamString(params);
        toSignStr += "&secretKey=" + secretKey;

        // md5生成信息摘要，并转为小写
        String md5Sign = Md5Utils.hash(toSignStr).toLowerCase();

        // 使用RSA2对信息摘要进行签名
        String sign = RsaUtil.sign(md5Sign, privateKey, true);
        params.put("sign", sign);

        String respStr = HttpUtils.sendPost(queryOrderUrl, params);

        if (respStr == null || "".equals(respStr)) {
            ///////////////////////////////
            // 3:网络不可靠因素、服务器报错  等不可预知的原因导致响应为空； 商户根据自身的业务逻辑做相应的处理（例如：重新发起查单等操作）
            ///////////////////////////////
            return "查单响应为空";
        }

        System.out.println("查单响应：" + respStr);

        QueryOrderResp queryOrderResp = JsonUtil.unmarshal(respStr, QueryOrderResp.class);
        QueryOrderResp.ResponseContent responseContent = queryOrderResp.getResponseContent();
        TreeMap<String, Object> respParams = new TreeMap<>();
        respParams.put("code", responseContent.getCode());
        respParams.put("msg", responseContent.getMsg());
        respParams.put("timestamp", responseContent.getTimestamp());
        respParams.put("orderNo", responseContent.getOrderNo());
        respParams.put("merchno", responseContent.getMerchno());
        respParams.put("orderId", responseContent.getOrderId());
        respParams.put("amount", responseContent.getAmount());
        respParams.put("account", responseContent.getAccount());
        respParams.put("tradeType", responseContent.getTradeType());
        respParams.put("cardNo", responseContent.getCardNo());
        respParams.put("bankName", responseContent.getBankName());
        respParams.put("depositBank", responseContent.getDepositBank());
        respParams.put("attach", responseContent.getAttach());
        respParams.put("status", responseContent.getStatus());
        respParams.put("requestCurrency", responseContent.getRequestCurrency());

        toSignStr = HttpUtils.buildParamString(respParams);
        toSignStr += "&secretKey=" +secretKey;
        // md5生成信息摘要，并转为小写
        md5Sign = Md5Utils.hash(toSignStr).toLowerCase();
        // 使用RSA2对信息摘要进行验签
        boolean isVerify = RsaUtil.verify(md5Sign, queryOrderResp.getSign(), platformPublicKey, true);

        if (!isVerify) {
            System.out.println("签名错误");
            return "签名错误:" + respStr;
        }
        if (0 != responseContent.getCode()) {
            ///////////////////////////////
            // 4:省略 根据状态码 结合 商户自身的业务逻辑进行相应的处理（例如：重新发起查单等操作）
            ///////////////////////////////
            System.out.println("查单失败" + respStr);
            return "查单失败" + respStr;
        }

        ///////////////////////////////
        // 5:省略 根据状态码、订单状态 结合 商户自身的业务逻辑进行相应的处理（例如：更新订单状态等操作）
        ///////////////////////////////

        return respStr;

    }

}
